<?php

namespace App\Http\Controllers\Administrator;

use App\Helpers\CommonHelpers;
use App\Models\Compaign;
use App\Models\Website;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\CampaignAds;

class CompaignController extends Controller
{

	public function index(Request $request)
	{
		$compaign = Compaign::with('website');

		$data = array(
			'title' => 'Compaigns',
			'all_compaigns' => $compaign->latest()->paginate(10),
			'websites' => Website::latest()->get(),
        );
		return view('admin.compaigns.index')->with($data);
	}

	public function add()
	{
		$data = array(
			'title' => 'Add Compaign',
			'websites' => Website::all(),
		);
		return view('admin.compaigns.add')->with($data);
	}

	public function save(Request $request)
	{
		$rules = [
			'name' => ['required', 'string'],
			'website_id' => ['required'],
            'start_date' => 'required|date_format:Y-m-d|before_or_equal:end_date',
            'end_date' => 'required|date_format:Y-m-d|after_or_equal:start_date'
		];

            // if (empty($request->id)) {
            // 	$rules['image'] = ['required'];
            // }

		$validator = Validator::make($request->all(), $rules);
		if ($validator->fails()) {
			return ['errors' => $validator->errors()];
		}

		$compaign = new  Compaign();
		if ($request->id) {
			$compaign = $compaign::hashidFind($request->id);
			$msg = [
				'success' => 'Compaign Successfully Updated',
				'redirect' => route('admin.compaigns'),
			];
		} else {
			$msg = [
				'success' => 'Compaign Successfully Added',
				'redirect' => route('admin.compaigns'),
			];
		}



		$compaign->website_id = $request->website_id;
		$compaign->name = $request->name;
        $compaign->start_date = $request->start_date;
        $compaign->end_date = $request->end_date;
		$compaign->save();

		return response()->json($msg);
	}

	public function edit($id)
	{
		$compaign = Compaign::hashidFind($id);
		$data = array(
			'title' => 'Edit Compaign',
			'edit' => $compaign,
			'websites' => Website::all(),
		);
		return view('admin.compaigns.add')->with($data);
	}

	public function delete($id)
	{
		$compaign = Compaign::hashidFind($id);
		if (file_exists($compaign->image)) {
			@unlink($compaign->image);
		}
		Compaign::where('id', $compaign->id)->delete();

		return response()->json([
			'success' => 'Compaign Successfully Deleted',
			'remove_tr' => true
		]);
	}

    public function set_campaign_ads($id)
    {
        $ads = CampaignAds::with('campaign')->where('campaign_id',hashids_decode($id))->paginate(10);

        $data = array(
            'title' => 'Compaigns Ads',
            'data' => $ads,
            'campaign_id' => $id,
        );

        return view('admin.compaigns.ads_image_form')->with($data);
    }

    public function edit_campaign_ads($id,$compaign_id)
    {
        $ads = CampaignAds::with('campaign')->where('campaign_id',hashids_decode($compaign_id))->paginate(10);

        $data = array(
            'title' => 'Compaigns Ads',
            'data' => $ads,
            'edit' => CampaignAds::hashidFind($id),
            'campaign_id' => $compaign_id,
        );

        return view('admin.compaigns.ads_image_form')->with($data);
    }

    public function campaign_ads_save(Request $request)
    {
        $rules = array(
            'ads_title' => 'required',
            'ads_link' => 'required',
            // 'ads_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|dimensions:width=930,height=180',
        );

        if (!isset($request->id)) {
            $rules['ads_image'] = 'required|image|mimes:jpeg,png,jpg,gif,svg|dimensions:width=930,height=180';
        }

        $validator = Validator::make($request->all(), $rules);
		if ($validator->fails()) {
			return ['errors' => $validator->errors()];
		}

        $compaign_ads = new CampaignAds();

        if (isset($request->id)) {
            $compaign_ads = $compaign_ads::find($request->id);
            $msg = [
				'success' => 'Compaign Ads Successfully Updated',
				'redirect' => route('admin.campaign_ads.set',$request->campaign_id),
			];
        }else{
            $msg = [
				'success' => 'Compaign Ads Successfully Added',
				'reload' => true,
			];
        }

        $compaign_ads->campaign_id = hashids_decode($request->campaign_id);
        $compaign_ads->title = $request->ads_title;
        $compaign_ads->link = $request->ads_link;
        if ($request->hasFile('ads_image')) {
            $image = CommonHelpers::uploadSingleFile($request->file('ads_image'), 'uploads/campaign_ads/');
            if (is_array($image)) {
                return response()->json($image);
            }
            if (file_exists($compaign_ads->image)) {
                @unlink($compaign_ads->image);
            }
            $compaign_ads->image = $image;
        }
        $compaign_ads->save();

        return response()->json($msg);
    }

    public function delete_campaign_ads($id)
	{
		$CampaignAds = CampaignAds::hashidFind($id);
		if (file_exists($CampaignAds->image)) {
			@unlink($CampaignAds->image);
		}
		CampaignAds::find($CampaignAds->id)->delete();

		return response()->json([
			'success' => 'Campaign Ads Successfully Deleted',
			'remove_tr' => true
		]);
	}

    public function ads_ifram_view(Request $request)
    {
        $CampaignAds = CampaignAds::hashidFind($request->id);

        return view('admin.compaigns.ifram')->with('data',$CampaignAds);
    }

    public function ads_ifram_generate(Request $request)
    {
        $CampaignAds = CampaignAds::hashidFind($request->id);

        $fram = '<iframe src="'.route('ads_ifram_view',$CampaignAds->hashid).'" style="height:180px;width:930px;" title="'.$CampaignAds->title.'"></iframe>';

        return response()->json(['view'=>$fram]);
    }

    public function update_click_count(Request $request)
    {
        $CampaignAds = CampaignAds::hashidFind($request->id);

        $CampaignAds->clicks = $CampaignAds->clicks + 1;
        $CampaignAds->save();

        return response()->json(['status' => 200]);
    }

    public function update_view_count(Request $request)
    {
        $CampaignAds = CampaignAds::hashidFind($request->id);

        $CampaignAds->views = $CampaignAds->views + 1;
        $CampaignAds->save();

        return response()->json(['status' => 200]);
    }
}
