@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.compaigns') }}">Compaigns</a></li>
                    <li class="breadcrumb-item active">{{$title}}</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card-box">
            <h4 class="header-title m-t-0">{{$title}}</h4>
            <p class="text-muted font-14 m-b-20">
                Here you can {{$title}}.
            </p>

            <form action="{{route('admin.compaign.save')}}" class="ajaxForm" method="post" enctype="multipart/form-data" novalidate>
                @csrf
                <div class="row">
                    <div class="form-group mb-3 col-md-6">
                        <label for="name">Name<span class="text-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="{{ $edit->name ?? '' }}" placeholder="Enter Compaign Name" required>
                    </div>
                    <div class="form-group mb-3 col-md-6">
                        <label for="organized_by">--Select Website--<span class="text-danger">*</span></label>
                        <select class="form-control" name="website_id" id="website_id" required>
                            <option value="">Select</option>
                            @foreach ($websites as $website)
                            <option value="{{$website->id}}" @if (!empty($edit)) {{ $website->id == $edit->website_id ? 'selected' : '' }} @endif>{{$website->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group mb-3 col-md-6">
                        <label for="start_date">Start Date<span class="text-danger">*</span></label>
                        <input class="form-control" type="date" name="start_date" value="{{ $edit->start_date ?? '' }}" required>
                    </div>
                    <div class="form-group mb-3 col-md-6">
                        <label for="end_date">End Date<span class="text-danger">*</span></label>
                        <input class="form-control" type="date" name="end_date" value="{{ $edit->end_date ?? '' }}" required>
                    </div>
                </div>
                <input type="hidden" name="id" value="{{ $edit->hashid ?? '' }}">
                <div class="form-group mb-3 text-right">
                    <button class="btn btn-primary" type="submit">
                        Submit
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('page-scripts')
<script>

</script>
<script>
    $(document).ready(function() {
        validations = $(".ajaxForm").validate();
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            validations = $(".ajaxForm").validate();
            if (validations.errorList.length != 0) {
                return false;
            }
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {

            });
        })
    });
</script>
@endsection
