@extends('layouts.front_auth')
@section('title', 'Register')
@section('page-heading', 'Register an account')
@section('auth_content')
<form method="POST" action="{{ route('register') }}" class="custom_form" novalidate>
    @csrf
    <div class="form-group mb-2">
        <label for="first_name">First Name <span class="text-danger">*</span></label>
        <input id="first_name" type="text" name="first_name" value="{{ old('first_name') }}" required class="form-control form__field @error('first_name') input--error @enderror" autofocus placeholder="Enter your first name">
        @error('first_name')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>

    <div class="form-group mb-2">
        <label for="last_name">Last Name <span class="text-danger">*</span></label>
        <input id="last_name" type="text" name="last_name" value="{{ old('last_name') }}" required class="form-control form__field @error('last_name') input--error @enderror" placeholder="Enter your last name">
        @error('last_name')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>

    <div class="form-group mb-2">
        <label for="emailaddress">E-Mail Address <span class="text-danger">*</span></label>
        <input id="emailaddress" type="email" name="email" value="{{ old('email') }}" required autocomplete="email" class="form-control form__field @error('email') input--error @enderror" placeholder="Enter your email">
        @error('email')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>

    <div class="form-group mb-2">
        <label for="password">Password  <span class="text-danger">*</span></label>
        <input class="form-control form__field @error('password') input--error @enderror" type="password" id="password" name="password" required placeholder="Enter your password">
        @error('password')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>

    <div class="form-group mb-2">
        <label for="password_confirmation">Confirm Password  <span class="text-danger">*</span></label>
        <input class="form-control form__field @error('password_confirmation') input--error @enderror" type="password" id="password_confirmation" name="password_confirmation" required placeholder="Confirm your password">
        @error('password_confirmation')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>

    @if ($errors->has('active'))
    <p class="alert alert-danger mt-2">
        <span class="help-block">
            <strong>{{ $errors->first('active') }}</strong>
        </span>
    </p>
    @endif

    <div class="heading">
        <p class="text-center">Already have an account? <a class="btn-link" href="{{ route('login') }}">Login!</a></p>
    </div>

    <div class="form-group mb-0 text-center">
        <button class="btn login btn-block text-white" type="submit">Register</button>
    </div>

</form>
@endsection